/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class SoulPartitionCastEffect
extends AsThoughEffectImpl {
    private final MageObjectReference mor;

    public SoulPartitionCastEffect(Card card, Game game) {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.Custom, Outcome.Benefit);
        this.mor = new MageObjectReference((MageObject)card, game);
    }

    private SoulPartitionCastEffect(SoulPartitionCastEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.mor = effect.mor;
    }

    public SoulPartitionCastEffect copy() {
        return new SoulPartitionCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Card card = this.mor.getCard(game);
        if (card == null) {
            this.discard();
            return false;
        }
        return this.mor.refersTo(CardUtil.getMainCardId((Game)game, (UUID)sourceId), game) && card.isOwnedBy(affectedControllerId);
    }
}

