/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.ManaUtil;

class SoulTitheEffect
extends OneShotEffect {
    SoulTitheEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "that player sacrifices it unless they pay {X}, where X is its mana value";
    }

    private SoulTitheEffect(SoulTitheEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent permanent;
        Permanent aura = game.getPermanent(source.getSourceId());
        if (aura != null && (permanent = game.getPermanent(aura.getAttachedTo())) != null && (player = game.getPlayer(permanent.getControllerId())) != null) {
            ManaCost cost = ManaUtil.createManaCost((int)permanent.getManaValue(), (boolean)true);
            if (player.chooseUse(Outcome.Benefit, "Pay " + cost.getText() + " for " + permanent.getName() + "? (otherwise you sacrifice it)", source, game) && cost.pay(source, game, source, player.getId(), false, null)) {
                return true;
            }
            permanent.sacrifice(source, game);
            return true;
        }
        return false;
    }

    public SoulTitheEffect copy() {
        return new SoulTitheEffect(this);
    }
}

