/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class SoullessJailerEnterEffect
extends ContinuousRuleModifyingEffectImpl {
    SoullessJailerEnterEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "permanent cards in graveyards can't enter the battlefield";
    }

    private SoullessJailerEnterEffect(SoullessJailerEnterEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public SoullessJailerEnterEffect copy() {
        return new SoullessJailerEnterEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getToZone() != Zone.BATTLEFIELD || zEvent.getFromZone() != Zone.GRAVEYARD) {
            return false;
        }
        Card card = game.getCard(zEvent.getTargetId());
        return card != null && card.isPermanent(game);
    }
}

