/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SparkOfCreativityPlayEffect
extends AsThoughEffectImpl {
    private final MageObjectReference objectReference;

    public SparkOfCreativityPlayEffect(MageObjectReference objectReference) {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.Benefit);
        this.objectReference = objectReference;
        this.staticText = "you may play that card until end of turn";
    }

    private SparkOfCreativityPlayEffect(SparkOfCreativityPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.objectReference = effect.objectReference;
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public SparkOfCreativityPlayEffect copy() {
        return new SparkOfCreativityPlayEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (this.objectReference.refersTo(objectId, game) && affectedControllerId.equals(source.getControllerId())) {
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null) {
                return true;
            }
            this.discard();
        }
        return false;
    }
}

