/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class SpatialBindingReplacementEffect
extends ContinuousRuleModifyingEffectImpl {
    SpatialBindingReplacementEffect() {
        super(Duration.UntilYourNextUpkeepStep, Outcome.Neutral);
        this.staticText = "until your next upkeep, target permanent can't phase out";
    }

    private SpatialBindingReplacementEffect(SpatialBindingReplacementEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public SpatialBindingReplacementEffect copy() {
        return new SpatialBindingReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PHASE_OUT;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.affectedObjectList.clear();
        this.affectedObjectList.add(new MageObjectReference(source.getFirstTarget(), game));
        this.setAffectedObjectsSet(true);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObjectReference targetMOR = new MageObjectReference(event.getTargetId(), game);
        return this.affectedObjectList.stream().anyMatch(mor -> mor.equals((Object)targetMOR));
    }
}

