/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class SpeakeasyServerEffect
extends OneShotEffect {
    SpeakeasyServerEffect() {
        super(Outcome.GainLife);
        this.staticText = "you gain 1 life for each other creature you control";
    }

    private SpeakeasyServerEffect(SpeakeasyServerEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpeakeasyServerEffect copy() {
        return new SpeakeasyServerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID controllerId = source.getControllerId();
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        controller.gainLife(game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE, controllerId, source, game), game, source);
        return true;
    }
}

