/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SpectacularShowdownEffect
extends OneShotEffect {
    SpectacularShowdownEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a double strike counter on target creature, then goad each creature that had a double strike counter put on it this way";
    }

    private SpectacularShowdownEffect(SpectacularShowdownEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpectacularShowdownEffect copy() {
        return new SpectacularShowdownEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || !permanent.addCounters(CounterType.DOUBLE_STRIKE.createInstance(), source, game)) {
            return false;
        }
        game.addEffect(new GoadTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

