/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class SpectraWard
extends CardImpl {
    private static final FilterCard filter = new FilterCard("all colors");

    public SpectraWard(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{3}{W}{W}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        ability = new SimpleStaticAbility((Effect)new BoostEnchantedEffect(2, 2, Duration.WhileOnBattlefield));
        ProtectionAbility protectionAbility = new ProtectionAbility((Filter)filter);
        protectionAbility.setRemovesAuras(false);
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)protectionAbility, AttachmentType.AURA, Duration.WhileOnBattlefield).setText("and has protection from all colors. This effect doesn't remove Auras"));
        this.addAbility((Ability)ability);
    }

    private SpectraWard(SpectraWard card) {
        super((CardImpl)card);
    }

    public SpectraWard copy() {
        return new SpectraWard(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{new ColorPredicate(ObjectColor.BLACK), new ColorPredicate(ObjectColor.BLUE), new ColorPredicate(ObjectColor.GREEN), new ColorPredicate(ObjectColor.RED), new ColorPredicate(ObjectColor.WHITE)}));
    }
}

