/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PhaseOutTargetEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.target.Target;
import mage.target.TargetPermanent;

class SpectralAdversaryEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("other artifacts, creatures, and/or enchantments");

    SpectralAdversaryEffect() {
        super(Outcome.Benefit);
        this.staticText = "put that many +1/+1 counters on {this}, then up to that many other target artifacts, creatures, and/or enchantments phase out";
    }

    private SpectralAdversaryEffect(SpectralAdversaryEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpectralAdversaryEffect copy() {
        return new SpectralAdversaryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Integer timesPaid = (Integer)this.getValue("timesPaid");
        if (timesPaid == null || timesPaid <= 0) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance(timesPaid.intValue())), false, this.staticText);
        ability.addEffect((Effect)new PhaseOutTargetEffect());
        ability.addTarget((Target)new TargetPermanent(0, timesPaid.intValue(), filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate()}));
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

