/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.s.SpectralArcanistTracker;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class SpectralArcanistCastEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.SPIRIT);
    private static final Hint hint = new ValueHint("Spirits you control", (DynamicValue)new PermanentsOnBattlefieldCount(filter));

    SpectralArcanistCastEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may cast an instant or sorcery spell with mana value less than or equal to the number of Spirits you control from a graveyard without paying its mana cost. If that spell would be put into a graveyard, exile it instead";
    }

    private SpectralArcanistCastEffect(SpectralArcanistCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpectralArcanistCastEffect copy() {
        return new SpectralArcanistCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        FilterInstantOrSorceryCard filterCard = new FilterInstantOrSorceryCard();
        filterCard.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, game.getBattlefield().count(filter, source.getControllerId(), source, game)));
        CardsImpl cards = new CardsImpl();
        game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getGraveyard).forEach(arg_0 -> ((Cards)cards).addAll(arg_0));
        return CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)cards, (FilterCard)filterCard, (CardUtil.SpellCastTracker)SpectralArcanistTracker.instance);
    }

    public static Hint getHint() {
        return hint;
    }
}

