/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.dynamicvalue.common.GreatestAmongPermanentsValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.ManaUtil;

class SpellRuptureCounterUnlessPaysEffect
extends OneShotEffect {
    SpellRuptureCounterUnlessPaysEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell unless its controller pays {X}, where X is the greatest power among creatures you control";
    }

    private SpellRuptureCounterUnlessPaysEffect(SpellRuptureCounterUnlessPaysEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpellRuptureCounterUnlessPaysEffect copy() {
        return new SpellRuptureCounterUnlessPaysEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject spell = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        Player player = game.getPlayer(spell.getControllerId());
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (player == null || controller == null || sourceObject == null) {
            return false;
        }
        int maxPower = GreatestAmongPermanentsValue.POWER_CONTROLLED_CREATURES.calculate(game, source, (Effect)this);
        ManaCost cost = ManaUtil.createManaCost((int)maxPower, (boolean)true);
        if (player.chooseUse(Outcome.Benefit, "Pay " + cost.getText() + ", where X is " + maxPower + "? (otherwise " + spell.getName() + " will be countered)", source, game) && cost.pay(source, game, source, player.getId(), false)) {
            return true;
        }
        game.informPlayers(sourceObject.getName() + ": cost wasn't payed - countering " + spell.getName());
        return game.getStack().counter(source.getFirstTarget(), source, game);
    }
}

