/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class SpelltwineEffect
extends OneShotEffect {
    SpelltwineEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Exile target instant or sorcery card from your graveyard and target instant or sorcery card from an opponent's graveyard. Copy those cards. Cast the copies if able without paying their mana costs";
    }

    private SpelltwineEffect(SpelltwineEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card cardOne = game.getCard(((Target)source.getTargets().get(0)).getFirstTarget());
        Card cardTwo = game.getCard(((Target)source.getTargets().get(1)).getFirstTarget());
        if (controller != null) {
            Card copyOne;
            if (cardOne != null) {
                controller.moveCards(cardOne, Zone.EXILED, source, game);
            }
            if (cardTwo != null) {
                controller.moveCards(cardTwo, Zone.EXILED, source, game);
            }
            boolean castCardOne = true;
            ApprovingObject approvingObject = new ApprovingObject(source, game);
            if (cardOne != null && controller.chooseUse(Outcome.Neutral, "Cast the copy of " + cardOne.getName() + " first?", source, game)) {
                copyOne = game.copyCard(cardOne, source, controller.getId());
                game.getState().setValue("PlayFromNotOwnHandZone" + copyOne.getId(), (Object)Boolean.TRUE);
                controller.cast(controller.chooseAbilityForCast(copyOne, game, true), game, true, approvingObject);
                game.getState().setValue("PlayFromNotOwnHandZone" + copyOne.getId(), null);
                castCardOne = false;
            }
            if (cardTwo != null) {
                Card copyTwo = game.copyCard(cardTwo, source, controller.getId());
                game.getState().setValue("PlayFromNotOwnHandZone" + copyTwo.getId(), (Object)Boolean.TRUE);
                controller.cast(controller.chooseAbilityForCast(copyTwo, game, true), game, true, approvingObject);
                game.getState().setValue("PlayFromNotOwnHandZone" + copyTwo.getId(), null);
            }
            if (cardOne != null && castCardOne) {
                copyOne = game.copyCard(cardOne, source, controller.getId());
                game.getState().setValue("PlayFromNotOwnHandZone" + copyOne.getId(), (Object)Boolean.TRUE);
                controller.cast(controller.chooseAbilityForCast(copyOne, game, true), game, true, approvingObject);
                game.getState().setValue("PlayFromNotOwnHandZone" + copyOne.getId(), null);
            }
            return true;
        }
        return false;
    }

    public SpelltwineEffect copy() {
        return new SpelltwineEffect(this);
    }
}

