/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.turn.TurnMod;

class SphinxOfTheSecondSunEffect
extends OneShotEffect {
    SphinxOfTheSecondSunEffect() {
        super(Outcome.Benefit);
        this.staticText = "there is an additional beginning phase after this phase. <i>(The beginning phase includes the untap, upkeep, and draw steps.)</i>";
    }

    private SphinxOfTheSecondSunEffect(SphinxOfTheSecondSunEffect effect) {
        super((OneShotEffect)effect);
    }

    public SphinxOfTheSecondSunEffect copy() {
        return new SphinxOfTheSecondSunEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TurnPhase turnPhase = game.getTurnPhaseType();
        for (TurnMod turnMod : game.getState().getTurnMods()) {
            if (!"sphinxSecondSun".equals(turnMod.getTag()) || !turnMod.getPlayerId().equals(source.getControllerId()) || turnMod.getAfterPhase() != turnPhase) continue;
            turnPhase = TurnPhase.BEGINNING;
            turnMod.withTag("sphinxSecondSunIgnore");
            break;
        }
        TurnMod newPhase = new TurnMod(source.getControllerId()).withExtraPhase(TurnPhase.BEGINNING, turnPhase).withTag("sphinxSecondSun");
        game.getState().getTurnMods().add(newPhase);
        return true;
    }
}

