/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.s.SphinxsDecreeCantCastEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SphinxsDecreeEffect
extends OneShotEffect {
    SphinxsDecreeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each opponent can't cast instant or sorcery spells during that player's next turn";
    }

    private SphinxsDecreeEffect(SphinxsDecreeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SphinxsDecreeEffect copy() {
        return new SphinxsDecreeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            SphinxsDecreeCantCastEffect effect = new SphinxsDecreeCantCastEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(opponentId));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

