/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SpiritualizeTriggeredAbility
extends DelayedTriggeredAbility {
    SpiritualizeTriggeredAbility() {
        super((Effect)new GainLifeEffect((DynamicValue)SavedDamageValue.MUCH), Duration.EndOfTurn, false);
        this.setTriggerPhrase("Until end of turn, whenever target creature deals damage, ");
    }

    private SpiritualizeTriggeredAbility(SpiritualizeTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public SpiritualizeTriggeredAbility copy() {
        return new SpiritualizeTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER || event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent target = game.getPermanent(this.getFirstTarget());
        if (target != null && event.getSourceId().equals(target.getId())) {
            for (Effect effect : this.getEffects()) {
                effect.setValue("damage", (Object)event.getAmount());
            }
            return true;
        }
        return false;
    }
}

