/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;

class SpitefulShadowsEffect
extends OneShotEffect {
    SpitefulShadowsEffect() {
        super(Outcome.Damage);
        this.staticText = "it deals that much damage to its controller";
    }

    private SpitefulShadowsEffect(SpitefulShadowsEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpitefulShadowsEffect copy() {
        return new SpitefulShadowsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Integer damageAmount = (Integer)this.getValue("damage");
        if (damageAmount != null) {
            Player player;
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent == null) {
                FixedTarget fixedTarget = (FixedTarget)this.getTargetPointer();
                permanent = (Permanent)game.getLastKnownInformation(fixedTarget.getTarget(), Zone.BATTLEFIELD, fixedTarget.getZoneChangeCounter());
            }
            if (permanent != null && (player = game.getPlayer(permanent.getControllerId())) != null) {
                player.damage(damageAmount.intValue(), permanent.getId(), source, game);
                return true;
            }
        }
        return false;
    }
}

