/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class SplitThePartyEffect
extends OneShotEffect {
    SplitThePartyEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Choose target player. Return half the creatures they control to their owner's hand, rounded up";
    }

    private SplitThePartyEffect(SplitThePartyEffect effect) {
        super((OneShotEffect)effect);
    }

    public SplitThePartyEffect copy() {
        return new SplitThePartyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || targetPlayer == null) {
            return false;
        }
        int numCreatures = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, targetPlayer.getId(), game);
        if (numCreatures > 0) {
            int halfCreatures = numCreatures / 2 + numCreatures % 2;
            FilterCreaturePermanent filter = new FilterCreaturePermanent("creatures controlled by " + targetPlayer.getName());
            filter.add((Predicate)new ControllerIdPredicate(targetPlayer.getId()));
            TargetPermanent target = new TargetPermanent(halfCreatures, halfCreatures, (FilterPermanent)filter, true);
            if (controller.chooseTarget(this.outcome, (Target)target, source, game)) {
                HashSet<Permanent> cardsToHand = new HashSet<Permanent>();
                for (UUID creatureId : target.getTargets()) {
                    Permanent card = game.getPermanent(creatureId);
                    if (card == null) continue;
                    cardsToHand.add(card);
                }
                controller.moveCards(cardsToHand, Zone.HAND, source, game);
            }
        }
        return true;
    }
}

