/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.target.common.TargetOpponent;

class SplitTheSpoilsEffect
extends OneShotEffect {
    SplitTheSpoilsEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile up to five target permanent cards from your graveyard and separate them into two piles. An opponent chooses one of those piles. Put that pile into your hand and the other into your graveyard";
    }

    private SplitTheSpoilsEffect(SplitTheSpoilsEffect effect) {
        super((OneShotEffect)effect);
    }

    public SplitTheSpoilsEffect copy() {
        return new SplitTheSpoilsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        if (player == null || cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        TargetCardInExile target = new TargetCardInExile(0, 5, StaticFilters.FILTER_CARD);
        target.withChooseHint("To put in pile 1").withNotTarget(true);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        ArrayList pile1 = new ArrayList();
        target.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).forEach(pile1::add);
        ArrayList pile2 = new ArrayList();
        cards.removeIf(target.getTargets()::contains);
        pile2.addAll(cards.getCards(game));
        TargetOpponent targetOpponent = new TargetOpponent();
        targetOpponent.withNotTarget(true);
        player.choose(this.outcome, (Target)targetOpponent, source, game);
        if (game.getPlayer(targetOpponent.getFirstTarget()).choosePile(this.outcome, "Choose a pile to go to hand (the other goes to graveyard)", pile1, pile2, game)) {
            player.moveCards((Cards)new CardsImpl(pile1), Zone.HAND, source, game);
            player.moveCards((Cards)new CardsImpl(pile2), Zone.GRAVEYARD, source, game);
        } else {
            player.moveCards((Cards)new CardsImpl(pile2), Zone.HAND, source, game);
            player.moveCards((Cards)new CardsImpl(pile1), Zone.GRAVEYARD, source, game);
        }
        return true;
    }
}

