/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;

public final class SpoilsOfEvil
extends CardImpl {
    private static final FilterCard filter = new FilterCard("artifact or creature card in target opponents graveyard");

    public SpoilsOfEvil(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{2}{B}");
        this.getSpellAbility().addEffect((Effect)new SpoilsOfEvilEffect());
        this.getSpellAbility().addTarget((Target)new TargetOpponent());
    }

    private SpoilsOfEvil(SpoilsOfEvil card) {
        super((CardImpl)card);
    }

    public SpoilsOfEvil copy() {
        return new SpoilsOfEvil(this);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.CREATURE.getPredicate()));
    }

    static class SpoilsOfEvilEffect
    extends OneShotEffect {
        public SpoilsOfEvilEffect() {
            super(Outcome.GainLife);
            this.staticText = "For each artifact or creature card in target opponent's graveyard, add {C} and you gain 1 life.";
        }

        private SpoilsOfEvilEffect(SpoilsOfEvilEffect effect) {
            super((OneShotEffect)effect);
        }

        public SpoilsOfEvilEffect copy() {
            return new SpoilsOfEvilEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Player targetOpponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            Player controller = game.getPlayer(source.getControllerId());
            if (targetOpponent != null && controller != null) {
                int cardCount = targetOpponent.getGraveyard().count(filter, game);
                controller.gainLife(cardCount, game, source);
                controller.getManaPool().addMana(Mana.ColorlessMana((int)cardCount), game, source);
                return true;
            }
            return false;
        }
    }
}

