/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class SpoilsOfTheVaultEffect
extends OneShotEffect {
    SpoilsOfTheVaultEffect() {
        super(Outcome.Damage);
        this.staticText = "Reveal cards from the top of your library until you reveal a card with that name, then put that card into your hand. Exile all other cards revealed this way, and you lose 1 life for each of the exiled cards";
    }

    private SpoilsOfTheVaultEffect(SpoilsOfTheVaultEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpoilsOfTheVaultEffect copy() {
        return new SpoilsOfTheVaultEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        Player controller = game.getPlayer(source.getControllerId());
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (sourceObject == null || controller == null || cardName == null || cardName.isEmpty()) {
            return false;
        }
        CardsImpl cardsToReveal = new CardsImpl();
        CardsImpl cardsToExile = new CardsImpl();
        for (Card card : controller.getLibrary().getCards(game)) {
            if (card == null) continue;
            cardsToReveal.add(card);
            if (CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) {
                controller.moveCards(card, Zone.HAND, source, game);
                break;
            }
            cardsToExile.add(card);
        }
        controller.revealCards(sourceObject.getIdName(), (Cards)cardsToReveal, game);
        controller.moveCards((Cards)cardsToExile, Zone.EXILED, source, game);
        controller.loseLife(cardsToExile.size(), game, source, false);
        return true;
    }
}

