/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SpyNetworkLookAtTargetPlayerHandEffect
extends OneShotEffect {
    SpyNetworkLookAtTargetPlayerHandEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at target player's hand,";
    }

    private SpyNetworkLookAtTargetPlayerHandEffect(SpyNetworkLookAtTargetPlayerHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpyNetworkLookAtTargetPlayerHandEffect copy() {
        return new SpyNetworkLookAtTargetPlayerHandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        MageObject sourceObject = game.getObject(source);
        if (you != null && targetPlayer != null) {
            you.lookAtCards("Hand of " + targetPlayer.getName() + " (" + (sourceObject != null ? sourceObject.getIdName() : null) + ')', targetPlayer.getHand(), game);
            return true;
        }
        return false;
    }
}

