/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.RollDieType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.RollDieEvent;

class SquirrelPoweredSchemeEffect
extends ReplacementEffectImpl {
    SquirrelPoweredSchemeEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Increase the result of each die you roll by 2";
    }

    private SquirrelPoweredSchemeEffect(SquirrelPoweredSchemeEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((RollDieEvent)event).incResultModifier(2);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ROLL_DIE && ((RollDieEvent)event).getRollDieType() == RollDieType.NUMERICAL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }

    public SquirrelPoweredSchemeEffect copy() {
        return new SquirrelPoweredSchemeEffect(this);
    }
}

