/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class StabWound
extends CardImpl {
    static final String rule = "At the beginning of the upkeep of enchanted creature's controller, that player loses 2 life";

    public StabWound(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{B}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.Detriment));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new BoostEnchantedEffect(-2, -2, Duration.WhileOnBattlefield)));
        this.addAbility((Ability)new BeginningOfUpkeepTriggeredAbility(TargetController.CONTROLLER_ATTACHED_TO, (Effect)new LoseLifeTargetEffect(2), false));
    }

    private StabWound(StabWound card) {
        super((CardImpl)card);
    }

    public StabWound copy() {
        return new StabWound(this);
    }
}

