/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class StanggLeavesTriggeredAbility
extends DelayedTriggeredAbility {
    StanggLeavesTriggeredAbility(Token token, Game game) {
        super((Effect)new ExileTargetEffect());
        this.getEffects().setTargetPointer((TargetPointer)new FixedTargets(token, game));
    }

    private StanggLeavesTriggeredAbility(StanggLeavesTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public StanggLeavesTriggeredAbility copy() {
        return new StanggLeavesTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getTargetId().equals(this.getSourceId()) && ((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD;
    }

    public String getRule() {
        return "Exile that token when {this} leaves the battlefield.";
    }
}

