/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.condition.common.GiftWasPromisedCondition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class StarfallInvocationEffect
extends OneShotEffect {
    StarfallInvocationEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy all creatures. If the gift was promised, return a creature card put into your graveyard this way to the battlefield under your control";
    }

    private StarfallInvocationEffect(StarfallInvocationEffect effect) {
        super((OneShotEffect)effect);
    }

    public StarfallInvocationEffect copy() {
        return new StarfallInvocationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CardsImpl yourCreatureCards = new CardsImpl();
        Player controller = game.getPlayer(source.getControllerId());
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            if (permanent == null || !permanent.destroy(source, game, false) || controller == null || !permanent.isOwnedBy(controller.getId())) continue;
            yourCreatureCards.add((Card)permanent);
        }
        if (controller != null && GiftWasPromisedCondition.TRUE.apply(game, source)) {
            game.processAction();
            TargetCardInYourGraveyard target = new TargetCardInYourGraveyard();
            controller.choose(Outcome.PutCreatureInPlay, (Cards)yourCreatureCards, (TargetCard)target, source, game);
            Card targetCard = game.getCard(target.getFirstTarget());
            if (targetCard != null) {
                controller.moveCards(targetCard, Zone.BATTLEFIELD, source, game);
            }
        }
        return true;
    }
}

