/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class StargazeEffect
extends OneShotEffect {
    StargazeEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at twice X cards from the top of your library. Put X cards from among them into your hand and the rest into your graveyard. You lose X life";
    }

    private StargazeEffect(StargazeEffect effect) {
        super((OneShotEffect)effect);
    }

    public StargazeEffect copy() {
        return new StargazeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (player == null || xValue < 1) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 2 * xValue));
        if (cards.size() > xValue) {
            TargetCardInLibrary target = new TargetCardInLibrary(xValue, StaticFilters.FILTER_CARD);
            player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
            player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.HAND, source, game);
            cards.retainZone(Zone.LIBRARY, game);
            player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        } else {
            player.moveCards((Cards)cards, Zone.HAND, source, game);
        }
        player.loseLife(xValue, game, source, false);
        return true;
    }
}

