/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class StarvingRevenantEffect
extends OneShotEffect {
    StarvingRevenantEffect() {
        super(Outcome.Benefit);
        this.staticText = "surveil 2. Then for each card you put on top of your library, you draw a card and you lose 3 life";
    }

    private StarvingRevenantEffect(StarvingRevenantEffect effect) {
        super((OneShotEffect)effect);
    }

    public StarvingRevenantEffect copy() {
        return new StarvingRevenantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int amountOnTop = controller.doSurveil(2, source, game).getNumberPutOnTop();
        for (int i = 0; i < amountOnTop; ++i) {
            controller.drawCards(1, source, game);
            controller.loseLife(3, game, source, false);
        }
        return true;
    }
}

