/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class StatecraftPreventionEffect
extends PreventionEffectImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();

    StatecraftPreventionEffect() {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, true);
        this.staticText = "Prevent all combat damage that would be dealt to and dealt by creatures you control";
    }

    private StatecraftPreventionEffect(StatecraftPreventionEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public StatecraftPreventionEffect copy() {
        return new StatecraftPreventionEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (super.applies(event, source, game)) {
            Permanent sourcePermanent = game.getPermanent(event.getSourceId());
            if (sourcePermanent != null && filter.match(sourcePermanent, source.getControllerId(), source, game)) {
                return true;
            }
            Permanent targetPermanent = game.getPermanent(event.getTargetId());
            if (targetPermanent != null && filter.match(targetPermanent, source.getControllerId(), source, game)) {
                return true;
            }
        }
        return false;
    }
}

