/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class StayHiddenStaySilentEffect
extends OneShotEffect {
    StayHiddenStaySilentEffect() {
        super(Outcome.Benefit);
        this.staticText = "shuffle enchanted creature into its owner's library";
    }

    private StayHiddenStaySilentEffect(StayHiddenStaySilentEffect effect) {
        super((OneShotEffect)effect);
    }

    public StayHiddenStaySilentEffect copy() {
        return new StayHiddenStaySilentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Optional.ofNullable(source.getSourcePermanentOrLKI(game)).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(permanent -> {
            Player player = game.getPlayer(permanent.getControllerId());
            if (player != null) {
                player.shuffleCardsToLibrary((Card)permanent, game, source);
            }
        });
        return true;
    }
}

