/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class SteerClearWatcher
extends Watcher {
    private final Set<MageObjectReference> spellsCastWithMountControlled = new HashSet<MageObjectReference>();
    private final FilterPermanent filter = new FilterPermanent(SubType.MOUNT, "");

    SteerClearWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell == null) {
            return;
        }
        if (0 == game.getBattlefield().countAll(this.filter, spell.getControllerId(), game)) {
            return;
        }
        this.spellsCastWithMountControlled.add(new MageObjectReference((MageObject)spell, game));
    }

    public void reset() {
        super.reset();
        this.spellsCastWithMountControlled.clear();
    }

    public boolean didControlMountOnCast(MageObjectReference mor) {
        return this.spellsCastWithMountControlled.contains(mor);
    }
}

