/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.players.Player;

class SternJudgeEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.SWAMP);

    SternJudgeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player loses 1 life for each Swamp they control.";
    }

    private SternJudgeEffect(SternJudgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SternJudgeEffect copy() {
        return new SternJudgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.loseLife(game.getBattlefield().countAll(filter, player.getId(), game), game, source, false);
        }
        return true;
    }
}

