/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class StillnessInMotionEffect
extends OneShotEffect {
    StillnessInMotionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then if your library has no cards in it, exile this enchantment and put five cards from your graveyard on top of your library in any order";
    }

    private StillnessInMotionEffect(StillnessInMotionEffect effect) {
        super((OneShotEffect)effect);
    }

    public StillnessInMotionEffect copy() {
        return new StillnessInMotionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getLibrary().hasCards()) {
            return false;
        }
        Optional.ofNullable(source.getSourcePermanentIfItStillExists(game)).ifPresent(permanent -> player.moveCards((Card)permanent, Zone.EXILED, source, game));
        int graveCount = Math.min(player.getGraveyard().size(), 5);
        if (graveCount < 1) {
            return true;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(graveCount);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        player.putCardsOnTopOfLibrary((Cards)new CardsImpl((Collection)target.getTargets()), game, source, true);
        return true;
    }
}

