/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DontUntapInControllersNextUntapStepTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class StitchersGraftTriggeredAbility
extends TriggeredAbilityImpl {
    public StitchersGraftTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DontUntapInControllersNextUntapStepTargetEffect());
    }

    private StitchersGraftTriggeredAbility(StitchersGraftTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public StitchersGraftTriggeredAbility copy() {
        return new StitchersGraftTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent equipment = game.getPermanent(this.sourceId);
        if (equipment != null && equipment.getAttachedTo() != null && event.getSourceId().equals(equipment.getAttachedTo())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever equipped creature attacks, it doesn't untap during its controller's next untap step.";
    }
}

