/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class StompingSlabsEffect
extends OneShotEffect {
    StompingSlabsEffect() {
        super(Outcome.Damage);
        this.staticText = "Reveal the top seven cards of your library, then put those cards on the bottom of your library in any order. If a card named Stomping Slabs was revealed this way, {this} deals 7 damage to any target";
    }

    private StompingSlabsEffect(StompingSlabsEffect effect) {
        super((OneShotEffect)effect);
    }

    public StompingSlabsEffect copy() {
        return new StompingSlabsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 7));
            if (!cards.isEmpty()) {
                controller.revealCards("Stomping Slabs", (Cards)cards, game);
                boolean stompingSlabsFound = false;
                for (UUID cardId : cards) {
                    Card card = game.getCard(cardId);
                    if (card == null || !card.getName().equals("Stomping Slabs")) continue;
                    stompingSlabsFound = true;
                    break;
                }
                controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
                if (stompingSlabsFound) {
                    DamageTargetEffect effect = new DamageTargetEffect(7);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(this.getTargetPointer().getFirst(game, source)));
                    effect.apply(game, source);
                }
            }
            return true;
        }
        return false;
    }
}

