/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class StorageMatrixRestrictionEffect
extends RestrictionEffect {
    private int turn;
    private boolean applies;
    private static final Set<String> choice = new HashSet<String>();
    private CardType type;

    StorageMatrixRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "As long as {this} is untapped, each player chooses artifact, creature, or land during their untap step. That player can untap only permanents of the chosen type this step";
    }

    private StorageMatrixRestrictionEffect(StorageMatrixRestrictionEffect effect) {
        super((RestrictionEffect)effect);
        this.type = effect.type;
        this.turn = effect.turn;
        this.applies = effect.applies;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (game.getTurnStepType() != PhaseStep.UNTAP || !permanent.isControlledBy(game.getActivePlayerId())) {
            return false;
        }
        if (game.getTurnNum() != this.turn) {
            this.applies = this.makeChoice(game, source);
        }
        if (this.applies) {
            return !permanent.getCardType(game).contains(this.type);
        }
        return false;
    }

    private boolean makeChoice(Game game, Ability source) {
        this.turn = game.getTurnNum();
        Permanent storageMatrix = game.getPermanent(source.getSourceId());
        if (storageMatrix != null && !storageMatrix.isTapped()) {
            String chosenType;
            ChoiceImpl choiceImpl = new ChoiceImpl(true);
            choiceImpl.setMessage("Untap which kind of permanent?");
            choiceImpl.setChoices(choice);
            Player player = game.getPlayer(game.getActivePlayerId());
            if (player != null && player.choose(this.outcome, (Choice)choiceImpl, game) && (chosenType = choiceImpl.getChoice()) != null) {
                game.informPlayers(storageMatrix.getLogName() + ": " + player.getLogName() + " chose to untap " + chosenType);
                this.type = chosenType.equals(CardType.ARTIFACT.toString()) ? CardType.ARTIFACT : (chosenType.equals(CardType.LAND.toString()) ? CardType.LAND : CardType.CREATURE);
                return true;
            }
        }
        return false;
    }

    public boolean canBeUntapped(Permanent permanent, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public StorageMatrixRestrictionEffect copy() {
        return new StorageMatrixRestrictionEffect(this);
    }

    static {
        choice.add(CardType.ARTIFACT.toString());
        choice.add(CardType.CREATURE.toString());
        choice.add(CardType.LAND.toString());
    }
}

