/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.Card;
import mage.cards.s.ExileTopCardLibraryCost;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.common.FilterLandCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class StormElementalEffect
extends OneShotEffect {
    private static final FilterLandCard filter = new FilterLandCard("snow land");

    public StormElementalEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "If the exiled card is a snow land, {this} gets +1/+1 until end of turn";
    }

    private StormElementalEffect(StormElementalEffect effect) {
        super((OneShotEffect)effect);
    }

    public StormElementalEffect copy() {
        return new StormElementalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = null;
            for (Cost cost : source.getCosts()) {
                if (!(cost instanceof ExileTopCardLibraryCost)) continue;
                card = ((ExileTopCardLibraryCost)cost).getCard();
            }
            if (card != null && filter.match(card, game)) {
                game.addEffect((ContinuousEffect)new BoostSourceEffect(1, 1, Duration.EndOfTurn), source);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SuperType.SNOW.getPredicate());
    }
}

