/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.cards.Card;
import mage.filter.Filter;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class StormHeraldAttachablePredicate
implements Predicate<Card> {
    private final UUID controllerId;

    public StormHeraldAttachablePredicate(UUID controllerId) {
        this.controllerId = controllerId;
    }

    public boolean apply(Card input, Game game) {
        for (Target target : input.getSpellAbility().getTargets()) {
            Filter filter = target.getFilter();
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, this.controllerId, game)) {
                if (!filter.match((Object)permanent, game)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Aura cards that can be attached to controlles creatures";
    }
}

