/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;

class StormKingsThunderCopyEffect
extends OneShotEffect {
    private final int xValue;

    StormKingsThunderCopyEffect(int xValue) {
        super(Outcome.Benefit);
        this.xValue = xValue;
    }

    private StormKingsThunderCopyEffect(StormKingsThunderCopyEffect effect) {
        super((OneShotEffect)effect);
        this.xValue = effect.xValue;
    }

    public StormKingsThunderCopyEffect copy() {
        return new StormKingsThunderCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (this.xValue < 1) {
            return false;
        }
        Spell spell = (Spell)this.getValue("spellCast");
        if (spell == null) {
            return false;
        }
        spell.createCopyOnStack(game, source, source.getControllerId(), true, this.xValue);
        return true;
    }
}

