/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.HashMap;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class StormOfFormsEffect
extends OneShotEffect {
    StormOfFormsEffect() {
        super(Outcome.Benefit);
        this.staticText = "copy it for each kind of counter among permanents you control. You may choose new targets for the copies";
    }

    private StormOfFormsEffect(StormOfFormsEffect effect) {
        super((OneShotEffect)effect);
    }

    public StormOfFormsEffect copy() {
        return new StormOfFormsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)this.getValue("spellCast");
        if (controller == null || spell == null) {
            return false;
        }
        int amount = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT, source.getControllerId(), source, game).stream().map(p -> p.getCounters(game)).map(HashMap::keySet).flatMap(Collection::stream).distinct().mapToInt(x -> 1).sum();
        if (amount > 0) {
            spell.createCopyOnStack(game, source, source.getControllerId(), true, amount);
            return true;
        }
        return false;
    }
}

