/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.s.StormOfSoulsChangeCreatureEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class StormOfSoulsReturnEffect
extends OneShotEffect {
    public StormOfSoulsReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return all creature cards from your graveyard to the battlefield. Each of them is a 1/1 Spirit with flying in addition to its other types.";
    }

    private StormOfSoulsReturnEffect(StormOfSoulsReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public StormOfSoulsReturnEffect copy() {
        return new StormOfSoulsReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        cards.retainZone(Zone.BATTLEFIELD, game);
        game.addEffect(new StormOfSoulsChangeCreatureEffect().setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game)), source);
        return true;
    }
}

