/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class StormWorldEffect
extends OneShotEffect {
    StormWorldEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals X damage to that player, where X is 4 minus the number of cards in their hand";
    }

    private StormWorldEffect(StormWorldEffect effect) {
        super((OneShotEffect)effect);
    }

    public StormWorldEffect copy() {
        return new StormWorldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            int damage = 4 - player.getHand().size();
            if (damage > 0) {
                player.damage(damage, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

