/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class StorrevDevkarinLichWatcher
extends Watcher {
    private final Set<MageObjectReference> cards = new HashSet<MageObjectReference>();

    StorrevDevkarinLichWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Card card;
        if (event.getType() == GameEvent.EventType.BEGIN_COMBAT_STEP_PRE) {
            this.cards.clear();
        }
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && ((ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD && (card = game.getCard(event.getTargetId())) != null && (card.isCreature(game) || card.isPlaneswalker(game))) {
            this.cards.add(new MageObjectReference((MageObject)card, game));
        }
    }

    boolean wasPutInAGraveyardThisCombat(UUID cardId, Game game) {
        for (MageObjectReference mor : this.cards) {
            if (!mor.refersTo(cardId, game)) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        super.reset();
        this.cards.clear();
    }
}

