/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageEverythingEffect;
import mage.abilities.effects.common.DrawCardAllEffect;
import mage.abilities.effects.common.discard.DiscardHandAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class StrategySchmategyffect
extends OneShotEffect {
    public StrategySchmategyffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Roll a six-sided die. {this} has the indicated effect.<br>1 - Do nothing.<br>2 - Destroy all artifacts.<br>3 - Destroy all lands.<br>4 - {this} deals 3 damage to each creature and each player.<br>5 - Each player discards their hand and draws seven cards.<br>6 - Repeat this process two more times";
    }

    private StrategySchmategyffect(StrategySchmategyffect effect) {
        super((OneShotEffect)effect);
    }

    public StrategySchmategyffect copy() {
        return new StrategySchmategyffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        int numTimesToDo = 1;
        if (controller != null) {
            while (numTimesToDo > 0) {
                int amount = controller.rollDice(Outcome.Detriment, source, game, 6);
                --numTimesToDo;
                if (amount == 2) {
                    List artifactPermanents = game.getBattlefield().getActivePermanents((FilterPermanent)new FilterArtifactPermanent(), controller.getId(), game);
                    for (Permanent permanent : artifactPermanents) {
                        permanent.destroy(source, game, false);
                    }
                    continue;
                }
                if (amount == 3) {
                    List landPermanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LANDS, controller.getId(), game);
                    for (Permanent permanent : landPermanents) {
                        permanent.destroy(source, game, false);
                    }
                    continue;
                }
                if (amount == 4) {
                    new DamageEverythingEffect(3, (FilterPermanent)new FilterCreaturePermanent()).apply(game, source);
                    continue;
                }
                if (amount == 5) {
                    new DiscardHandAllEffect().apply(game, source);
                    new DrawCardAllEffect(7).apply(game, source);
                    continue;
                }
                if (amount != 6) continue;
                numTimesToDo += 2;
            }
        }
        return false;
    }
}

