/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class StrefanMaurerProgenitorPlayVampireEffect
extends OneShotEffect {
    private static final FilterCreatureCard vampireCardFilter = new FilterCreatureCard();

    public StrefanMaurerProgenitorPlayVampireEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "you may put a Vampire card from your hand onto the battlefield tapped and attacking. It gains indestructible until end of turn.";
    }

    private StrefanMaurerProgenitorPlayVampireEffect(StrefanMaurerProgenitorPlayVampireEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)vampireCardFilter);
        if (!player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game)) {
            return false;
        }
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, true, null);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        game.getCombat().addAttackingCreature(permanent.getId(), game);
        GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn);
        effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }

    public StrefanMaurerProgenitorPlayVampireEffect copy() {
        return new StrefanMaurerProgenitorPlayVampireEffect(this);
    }

    static {
        vampireCardFilter.add((Predicate)SubType.VAMPIRE.getPredicate());
    }
}

