/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class StriderRangerOfTheNorthEffect
extends OneShotEffect {
    StriderRangerOfTheNorthEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then if that creature has power 4 or greater, it gains first strike until end of turn.";
    }

    private StriderRangerOfTheNorthEffect(StriderRangerOfTheNorthEffect effect) {
        super((OneShotEffect)effect);
    }

    public StriderRangerOfTheNorthEffect copy() {
        return new StriderRangerOfTheNorthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (permanent.getPower().getValue() >= 4) {
            GainAbilityTargetEffect firstStrike = new GainAbilityTargetEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn);
            firstStrike.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)firstStrike, source);
        }
        return true;
    }
}

