/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class StromgaldSpyEffect
extends ContinuousEffectImpl {
    StromgaldSpyEffect() {
        super(Duration.Custom, Layer.PlayerEffects, SubLayer.NA, Outcome.Detriment);
    }

    private StromgaldSpyEffect(StromgaldSpyEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && sourcePermanent != null) {
            Player defender = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (defender != null) {
                defender.revealCards(defender.getName() + "'s hand cards", defender.getHand(), game, false);
            }
            return true;
        }
        return false;
    }

    public StromgaldSpyEffect copy() {
        return new StromgaldSpyEffect(this);
    }
}

