/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class StrongholdDisciplineEffect
extends OneShotEffect {
    StrongholdDisciplineEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Each player loses 1 life for each creature they control";
    }

    private StrongholdDisciplineEffect(StrongholdDisciplineEffect effect) {
        super((OneShotEffect)effect);
    }

    public StrongholdDisciplineEffect copy() {
        return new StrongholdDisciplineEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player;
                int count = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, playerId, game).size();
                if (count <= 0 || (player = game.getPlayer(playerId)) == null) continue;
                player.loseLife(count, game, source, false);
            }
            return true;
        }
        return false;
    }
}

