/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class StruggleForProjectDrawEffect
extends OneShotEffect {
    StruggleForProjectDrawEffect() {
        super(Outcome.DrawCard);
        this.staticText = "each opponent draws a card. You draw a card for each card drawn this way.";
    }

    private StruggleForProjectDrawEffect(StruggleForProjectDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public StruggleForProjectDrawEffect copy() {
        return new StruggleForProjectDrawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int count = game.getOpponents(source.getControllerId(), true).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).mapToInt(player -> player.drawCards(1, source, game)).sum();
        if (count > 0) {
            controller.drawCards(count, source, game);
            return true;
        }
        return false;
    }
}

