/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.CommanderPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetPermanentAmount;

class StumpsquallHydraEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("this permanent or any number of commanders");

    StumpsquallHydraEffect() {
        super(Outcome.Benefit);
        this.staticText = "distribute X +1/+1 counters among it and any number of commanders";
    }

    private StumpsquallHydraEffect(StumpsquallHydraEffect effect) {
        super((OneShotEffect)effect);
    }

    public StumpsquallHydraEffect copy() {
        return new StumpsquallHydraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int xValue = GetXValue.instance.calculate(game, source, (Effect)this);
        if (player == null || xValue < 1 || game.getBattlefield().count(filter, player.getId(), source, game) < 1) {
            return false;
        }
        TargetPermanentAmount targetAmount = new TargetPermanentAmount(xValue, 1, filter);
        targetAmount.withNotTarget(true);
        targetAmount.chooseTarget(this.outcome, player.getId(), source, game);
        for (UUID targetId : targetAmount.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(targetAmount.getTargetAmount(targetId)), source.getControllerId(), source, game);
        }
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)StumpsquallHydraPredicate.instance);
    }

    private static enum StumpsquallHydraPredicate implements ObjectSourcePlayerPredicate<MageObject>
    {
        instance;


        public boolean apply(ObjectSourcePlayer<MageObject> input, Game game) {
            return ((MageObject)input.getObject()).getId().equals(input.getSourceId()) || CommanderPredicate.instance.apply((MageObject)input.getObject(), game);
        }

        public String toString() {
            return "";
        }
    }
}

