/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class SubiraTulzidiCaravannerAbility
extends DelayedTriggeredAbility {
    SubiraTulzidiCaravannerAbility() {
        super((Effect)new DrawCardSourceControllerEffect(1), Duration.EndOfTurn, false, false);
    }

    private SubiraTulzidiCaravannerAbility(SubiraTulzidiCaravannerAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent dEvent = (DamagedPlayerEvent)event;
        if (!dEvent.isCombatDamage()) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        return permanent != null && permanent.isControlledBy(this.getControllerId()) && permanent.isCreature(game) && permanent.getPower().getValue() <= 2;
    }

    public SubiraTulzidiCaravannerAbility copy() {
        return new SubiraTulzidiCaravannerAbility(this);
    }

    public String getRule() {
        return "Until end of turn, whenever a creature you control with power 2 or less deals combat damage to a player, draw a card.";
    }
}

